//
// Copyright (c) 2007 Sami Visnen
//
// Permission is hereby granted, free of charge, to any person
// obtaining a copy of this software and associated documentation
// files (the "Software"), to deal in the Software without
// restriction, including without limitation the rights to use,
// copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following
// conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
// HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
//


// $Id: widget.h,v 1.5 2008/05/05 23:32:50 enska Exp $

#ifndef WIDGET_WIDGET_H
#define WIDGET_WIDGET_H

#include "frame_buffer.h"
#include "common.h"

namespace ui
{
    // Widget interface class. 
    class widget
    {
    public:
        virtual ~widget() {}

        // Should return whether the widget supports focusing.
        virtual bool can_focus() const   { return false; }

        // If the widget supports focusing request the widget to update its focus state.
        virtual void set_focus(bool val) { };

        // Request the widget to update the cursor position.
        virtual void set_cursor(cursor& c) { };

        // Invalidate the whole widget. 
        virtual void invalidate(bool force) { valid_ = false; }

        // Validate the whole widget.
        virtual void validate() { valid_ = true; }

        // Process a keypress. Raw should be the raw ASCII character
        // that was read as input. VK may describe a virtual key that is to be
        // executed. If not virtual key was generated by the raw input vk should be -1.
        // The keydown function should return true if the key event was handled.
        // Otherwise it should return false.
        virtual bool keydown(int raw, int vk) { return false; }
    
        // Animate this widget. A widget that supports some kind of animation
        // should return a rectangle that describes the area which it has updated in 
        // the frame buffer. 
        // Default implementation is to provide an empty animate rc.
        virtual rect animate(frame_buffer& fb, int elapsed) 
        {  
            rect ret = {};
            return ret;
        }
        
        // Erase are from the frame buffer. This is used when a widget
        // displays data only in some special circumstances (such as a menu or a drop down list)
        // and has a need to have this data erased from the frame buffer. (list closed, menu closed etc.)
        // The function should return a rectangle describing the area that needs to be cleared.
        // Default implementation is to do nothing and provide an empty erase rect.
        virtual rect erase()
        {
            rect ret = {};
            return ret;
        }

        // Get the validity of the widget. If the widget is valid
        // it doesn't need to draw itself. If it is not valid, it needs to draw.
        virtual bool is_valid() const { return valid_; }

        // Get widget height. Every widget needs to be able to report its height.
        virtual int height() const = 0;
        
        // Get widget width. Every widget needst to be able to report its width.
        virtual int width() const = 0;

        // Request widget to draw itself into the specified
        // frame buffer. Every widget must support drawing.
        virtual rect draw(frame_buffer& fb) = 0;


        // Set widget position. Relative to frame buffer when drawing.
        inline void position(int xpos, int ypos)
        {
            xpos_ = xpos;
            ypos_ = ypos;
        }

        // Get widget X position. Relative to the frame buffer.
        inline int xpos() const
        {
            return xpos_;
        }
        // Get widget Y position. Relative to the frame buffer.
        inline int ypos() const
        {
            return ypos_;
        }
        
    protected:
        widget(int x, int y) : xpos_(x), ypos_(y), valid_(false) {}
        widget() : xpos_(0), ypos_(0), valid_(false) {}

        int  xpos_;
        int  ypos_;
        bool valid_;
    private:
    };

} // ui

#endif // WIDGET_WIDGET_H
