//
// taskswapper - Maemo5 hotkey based task swapper
//
// Copyright (C) 2010 Sami Väisänen   samiv@ensisoft.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
//
//
//
// $Id: mainwindow.cpp,v 1.2 2010/02/18 16:51:07 svaisane Exp $
//

#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "../version.h"
#include <QMessageBox>
#include <QAbstractButton>

namespace gui
{

MainWindow::MainWindow() : ui_(NULL)
{
    ui_ = new Ui::MainWindow;
    ui_->setupUi(this);
}
 
MainWindow::~MainWindow()     
{
    delete ui_;
}

void MainWindow::on_actionAbout_triggered()
{
    QMessageBox msg(this);
    msg.setStandardButtons(QMessageBox::Ok);
    msg.setIcon(QMessageBox::Information);
    msg.setWindowTitle(tr("About"));
    msg.button(QMessageBox::Ok)->setMinimumSize(112, 70);
    msg.setText(QString::fromUtf8(
                "TaskSwapper " TASK_SWAPPER_VERSION "  " __DATE__ "\n"
                "(c) Sami Väisänen\n"
                "samiv@ensisoft.com"));
                   
    msg.exec();
}

} // gui
