
// $Id: trayapp.cpp,v 1.6 2008/02/24 17:16:44 enska Exp $

#define  WINVER      0x0501
#define _WIN32_WINNT 0x0501

#include <ui.h>
#include <windows.h>
#include <psapi.h>
#include <exception>
#include <string>
#include <cassert>
#include <boost/bind.hpp>
#include "res/resource.h"
#include "settings.h"
#include "trayapp.h"
#include "icon.h"
#include "registry.h"

using namespace winui;
using namespace trayapp;
using namespace std;

settings   gSettings;   // Settings object
container  gWindows;    // Hidden window collection
trayicon   gIcon;       // Application tray icon
basic_window<msgwindow, dynevent, blank>     gMsg;    // Internal message window
basic_window<sdiwindow, dynevent, icon_view> gWindow; // Hidden window Icon view

HMENU gMenu;            // cached menu object
HWND  gLastWindow;      // previously hidden window

std::string get_process_filename(HWND hwnd)
{
    DWORD id;
    GetWindowThreadProcessId(hwnd, &id);
    HANDLE proc = OpenProcess(PROCESS_QUERY_INFORMATION | PROCESS_VM_READ, FALSE, id);

    HMODULE mod;
    DWORD dummy;
    EnumProcessModules(proc, &mod, sizeof(mod), &dummy);

    char dodgy[256] = {};
    GetModuleFileNameEx(proc, mod, dodgy, sizeof(dodgy));
    CloseHandle(proc);

    std::string ret(dodgy);
    return ret;
}

std::string get_window_text(HWND hwnd)
{
    char dodgy[256] = {};
    GetWindowText(hwnd, dodgy, sizeof(dodgy));
    
    std::string s(dodgy);
    return s;
}

void hide_window(HWND hwnd, bool smooth)
{
    if (!smooth)
    {
        ShowWindow(hwnd, SW_HIDE);
        return;
    }

    LONG_PTR dStyle = GetWindowLongPtr(hwnd, GWL_EXSTYLE);

    SetWindowLongPtr(hwnd, GWL_EXSTYLE, dStyle | WS_EX_LAYERED);

    for (int i=100; i>0; i-=10)
    {
        int alpha = 255 * i / 100;
        SetLayeredWindowAttributes(hwnd, 0, (BYTE)alpha, ULW_ALPHA);
        Sleep(20);
    }
    ShowWindow(hwnd, SW_HIDE);
    SetWindowLongPtr(hwnd, GWL_EXSTYLE, dStyle);
}

void show_window(HWND hwnd, bool smooth)
{
    if (!smooth)
    {
        ShowWindow(hwnd, SW_SHOW);
        return;
    }
    LONG_PTR dStyle = GetWindowLongPtr(hwnd, GWL_EXSTYLE);

    SetWindowLongPtr(hwnd, GWL_EXSTYLE, dStyle | WS_EX_LAYERED);
    for (int i=0; i<=100; i+=10)
    {
        int alpha = 255 * i / 100;
        SetLayeredWindowAttributes(hwnd, 0, (BYTE)alpha, ULW_ALPHA);
        if (alpha == 0)
        {
            ShowWindow(hwnd, SW_SHOW);
        }
        Sleep(20);
    }
    SetWindowLongPtr(hwnd, GWL_EXSTYLE, dStyle);
}

void do_hotkey_open_menu()
{
    if (!gWindow.is_visible())
    {
        // alt+tab dialog doesnt come up either if there are 
        // no open windows on the desktop.
        if (gWindows.empty())
            return;

        int x = GetSystemMetrics(SM_CXSCREEN);
        int y = GetSystemMetrics(SM_CYSCREEN);

        gWindow.reset_selection();
        gWindow.size(300, 90);
        gWindow.position((x-300)/2, (y-90)/2);
        gWindow.show();
    }
    else
    {
        gWindow.move_selection_to_next_icon();
        gWindow.invalidate();
    }

    SetForegroundWindow(gWindow.hwnd());
}

#undef small

void do_hotkey_hide_window()
{
    HWND hwnd = GetForegroundWindow();

    if (hwnd == gWindow.hwnd())
        return; // cant hide the popup window

    // there seems to be a problem with the window activation
    // even though a window has been hidden already its possible to 
    // have the GetForegroundWindow still pick it up as the fg window.
    // so check here and return if this is case.
    if (hwnd == gLastWindow ||
        hwnd == GetDesktopWindow() ||
        hwnd == GetShellWindow())
        return;

    DWORD dStyle = GetWindowLongPtr(hwnd, GWL_STYLE);
    if (!(dStyle & WS_OVERLAPPED)       && 
        !(dStyle & WS_OVERLAPPEDWINDOW) &&
        !(dStyle & WS_POPUP))
        return;

    std::string file = get_process_filename(hwnd);
    std::string text = get_window_text(hwnd);

    HMENU submenu = GetSubMenu(gMenu, 0);
    HMENU wndmenu = GetSubMenu(submenu, 0);

    HICON small[1] = {};
    HICON large[1] = {};
    ExtractIconEx(file.c_str(), 0, large, small, 1);

    // create and add a window tag
    trayapp::window_tag t;
    t.hwnd       = hwnd;
    t.icon_small = small[0];
    t.icon_large = large[0];
    t.caption    = text;
    
    gWindows.push_back(t);

    // and also add the window the menu
    AppendMenu(wndmenu, MF_STRING, (UINT)hwnd, text.c_str());

    hide_window(hwnd, gSettings.smooth_hide);

    // see comments in the beginning of the function
    gLastWindow = hwnd;
}

void hotkey_press(const winui::evtarg& args)
{
    switch (args.wParam)
    {
        case hotkey_hide_window: do_hotkey_hide_window(); break;
        case hotkey_open_menu:   do_hotkey_open_menu();   break;
        default: assert(0); break;
    }
}

void erase_window_tag(HWND hwnd)
{
    trayapp::container::iterator it = gWindows.begin();
    for (; it != gWindows.end(); ++it)
    {
        const trayapp::window_tag& t = *it;
        if (it->hwnd == hwnd)
        {
            BOOL ret;
            ret = DestroyIcon(t.icon_large);
            assert(ret == TRUE);
            ret = DestroyIcon(t.icon_small);
            assert(ret == TRUE);
            gWindows.erase(it);
            break;
        }
    }    
}

void erase_window_menu(HWND hwnd)
{
    HMENU submenu = GetSubMenu(gMenu,   0);
    HMENU wndmenu = GetSubMenu(submenu, 0);
    assert(wndmenu);

    RemoveMenu(wndmenu, (UINT)hwnd, MF_BYCOMMAND);
}

void icon_clicked(const evtarg& args)
{
    if (args.lParam != WM_LBUTTONUP && args.lParam != WM_RBUTTONUP)
        return;

    HMENU menu = 0;
    if (args.lParam == WM_LBUTTONUP)
    {
        menu = GetSubMenu(GetSubMenu(gMenu, 0), 0);
    }
    if (args.lParam == WM_RBUTTONUP)
    {
        menu = GetSubMenu(gMenu, 0);
    }

    POINT pt;
    GetCursorPos(&pt);
    
    SetForegroundWindow(gMsg.hwnd()); // http://support.microsoft.com/kb/q135788/

    UINT cmd = TrackPopupMenu(
        menu,
        TPM_BOTTOMALIGN | TPM_RIGHTALIGN | TPM_RETURNCMD,
        pt.x, 
        pt.y,
        0,
        gMsg.hwnd(),
        NULL);
    switch (cmd)
    {
        case ID_ABOUT:
            MessageBox(gMsg.hwnd(),
                "Window Stealth (c) 2006, 2007 Sami Visnen\r\nversion 1.1\r\n"
                "http://www.ensisoft.com",
                "About Window Stealth",
                MB_OK | MB_ICONINFORMATION);
            break;

        case ID_EXIT:
            PostQuitMessage(0);
            break;

        case ID_OPTIONS:
            {
                EnableMenuItem(menu, ID_OPTIONS, MF_GRAYED);
                settings_dlg dlg(gMsg.hwnd());
                dlg.show(&gSettings);
                EnableMenuItem(menu, ID_OPTIONS, MF_ENABLED);
                if (gSettings.hideicon)
                    gIcon.rem();
            }
            break;

        case ID_NONE:
            break;

        default:
            {
                HWND hwnd = reinterpret_cast<HWND>(cmd);
                if (gLastWindow == hwnd)
                    gLastWindow = 0;

                show_window(hwnd, gSettings.smooth_hide);

                erase_window_menu(hwnd);
                erase_window_tag(hwnd);
            }
            break;
    } // switch
}

void icon_restore(const evtarg& args)
{
    gSettings.hideicon = false;
    if (!gIcon.visible())
        gIcon.add("Window Stealth", gMsg.hwnd(), WM_ICON_CLICKED, IDI_ICON1);
}

void selection_window_keyup(const winui::evtarg& args)
{
    int vk = gSettings.hotmenu & 0xFF;
    if (args.wParam == vk)
        return;

    gWindow.hide();

    if (gWindows.size() == 0)
        return;
    
    int sel = gWindow.selection();
    assert(sel >= 0 && sel < static_cast<int>(gWindows.size()));

    trayapp::container::iterator it = gWindows.begin();
    std::advance(it, sel);

    trayapp::window_tag t = *it;

    if (gLastWindow == t.hwnd)
        gLastWindow = 0;

    SetForegroundWindow(t.hwnd);

    show_window(t.hwnd, gSettings.smooth_hide);

    erase_window_menu(t.hwnd);
    erase_window_tag(t.hwnd);

}

void restore_windows()
{
    // restore all hidden windows.
    for (trayapp::container::iterator it = gWindows.begin(); it != gWindows.end(); ++it)
    {
        const trayapp::window_tag& t = *it;
        show_window(t.hwnd, gSettings.smooth_hide);
    }
}



void selection_window_loose_focus(const winui::evtarg&)
{
    gWindow.hide();
}

void load_settings(trayapp::settings& set)
{
    trayapp::registry r;
    if (r.open("Software\\Window Stealth"))
    {
        if (trayapp::has_value(r.key, "hide"))
            set.hideapp = trayapp::read_int(r.key, "hide");
        if (trayapp::has_value(r.key, "menu"))
            set.hotmenu = trayapp::read_int(r.key, "menu");
        if (trayapp::has_value(r.key, "smooth"))
            set.smooth_hide = trayapp::read_int(r.key, "smooth") != 0;
        if (trayapp::has_value(r.key, "hideicon"))
            set.hideicon = trayapp::read_int(r.key, "hideicon") != 0;
    }
    r.close();
    set.winstart = false;
    if (r.open("Software\\Microsoft\\Windows\\CurrentVersion\\Run"))
    {
        if (trayapp::has_value(r.key, "WindowStealth"))
            set.winstart = true;
    }
}

void save_settings(const trayapp::settings& set)
{
    trayapp::registry r;
    r.create("Software\\Window Stealth");
    
    trayapp::write_int(r.key, "hide",   set.hideapp);
    trayapp::write_int(r.key, "menu",   set.hotmenu);
    trayapp::write_int(r.key, "smooth", set.smooth_hide);
    r.close();

    r.create("Software\\Microsoft\\Windows\\CurrentVersion\\Run");
    if (set.winstart)
    {
        char buff[256] = {};
        GetModuleFileName(NULL, buff, sizeof(buff));

        std::string s(buff);
        trayapp::write_string(r.key, "WindowStealth", s);
    }
    else
    {
        trayapp::delete_value(r.key, "WindowStealth");
    }
}

void install_keys(trayapp::settings& set, HWND where)
{
    if (set.hideapp)
    {
        if (!RegisterHotKey(where, trayapp::hotkey_hide_window, set.hideapp >> 8, set.hideapp & 0xFF))
            set.hideapp = 0;
    }
    if (set.hotmenu)
    {
        if (!RegisterHotKey(where, trayapp::hotkey_open_menu, set.hotmenu >> 8, set.hotmenu & 0xFF))
            set.hotmenu = 0;
    }
}

void end_session(const winui::evtarg&)
{
    // windows sends WM_ENDSESSION when the system is being
    // shut down or the user is logging off.
    save_settings(gSettings);
    restore_windows();
}


int WINAPI WinMain(HINSTANCE, HINSTANCE, LPTSTR, int)
{
    gMsg.set_class_name("window_stealth_class");

    HANDLE mutex = CreateMutex(NULL, TRUE, "window_stealth_mutex");
    if (mutex && GetLastError() == ERROR_ALREADY_EXISTS)
    {
        // send the restore icon message
        HWND prev = FindWindow("window_stealth_class", NULL);
        assert(prev);
        BOOL ret = SendMessage(prev, WM_ICON_RESTORE, 0, 0);
        //assert(ret);
        CloseHandle(mutex);
        return 0;
    }
    try
    {
        gMenu = LoadMenu(GetModuleHandle(NULL), MAKEINTRESOURCE(IDR_MENU2));
        assert(gMenu);
        
        gMsg.bind(WM_HOTKEY, hotkey_press);
        gMsg.bind(WM_ICON_CLICKED, icon_clicked);
        gMsg.bind(WM_ICON_RESTORE, icon_restore);
        gMsg.open();

        gWindow.bind(WM_KEYUP, selection_window_keyup);
        gWindow.bind(WM_KILLFOCUS, selection_window_loose_focus);
        gWindow.bind(WM_ENDSESSION, end_session); 
        gWindow.wndstyle = WS_POPUP | WS_BORDER;
        // when the parent of the icon window is an invisible window
        // it will not have an entry in the taskbar
        gWindow.parent   = gMsg.hwnd();
        gWindow.open();
        gWindow.hide();
        gWindow.set_icon_array(&gWindows);

        // set some defaults in case there are no previous settings.
        memset(&gSettings, 0, sizeof(settings));
        gSettings.hideicon = false;
        gSettings.winstart = false;

        load_settings(gSettings);

        install_keys(gSettings, gMsg.hwnd());
        
        if (!gSettings.hideicon)
            gIcon.add("Window Stealth", gMsg.hwnd(), WM_ICON_CLICKED, IDI_ICON1);

        MSG m;
        while (GetMessage(&m, 0, 0, 0))
        {
            TranslateMessage(&m);
            DispatchMessage(&m);
        }

        restore_windows();
        save_settings(gSettings);
    }
    catch (const std::exception & e)
    {
        MessageBox(NULL, e.what(), "Window Stealth", MB_ICONERROR);
    }
    CloseHandle(mutex);
    return 0;
}
