
// $Id: settings.cpp,v 1.3 2008/02/24 17:16:44 enska Exp $

#include "res/resource.h"
#include "settings.h"
#include "trayapp.h"
#include <boost/bind.hpp>

namespace trayapp
{

settings_dlg::settings_dlg(HWND hotkey_window) : config_(0), hotkey_window_(hotkey_window)
{
    dlg_.connect(&hk_hide_,  IDC_HOTKEY1);
    dlg_.connect(&hk_menu_,  IDC_HOTKEY2);
    dlg_.connect(&smooth_,   IDC_CHECK1);
    dlg_.connect(&winstart_, IDC_CHECK2);
    dlg_.connect(&hideicon_, IDC_CHECK3);
    dlg_.connect(&accept_,   IDOK);
    dlg_.evtcreate   = boost::bind(&settings_dlg::create, this);
    dlg_.evtclose    = boost::bind(&settings_dlg::close,  this);
    accept_.evtclick = boost::bind(&settings_dlg::close,  this);
}

void settings_dlg::show(settings* conf)
{
    config_    = conf;
    dlg_.resid = IDD_DIALOG1;
    dlg_.open();
}

void settings_dlg::close()
{
    int val = hk_hide_.as_int();
    if (val == 0 && config_->hideapp)
        UnregisterHotKey(hotkey_window_, hotkey_hide_window);
    
    if (val && val != config_->hideapp)
    {
        UnregisterHotKey(hotkey_window_, hotkey_hide_window);
        if (!RegisterHotKey(hotkey_window_, hotkey_hide_window, hk_hide_.modifier(), hk_hide_.virtkey()))
        {
            MessageBeep(0);
            hk_hide_.focus();
            return;
        }
    }

    config_->hideapp = val;
    
    val = hk_menu_.as_int();
    if (val == 0 && config_->hotmenu)
        UnregisterHotKey(hotkey_window_, hotkey_open_menu);
    
    if (val && val != config_->hotmenu)
    {
        UnregisterHotKey(hotkey_window_, hotkey_open_menu);
        if (!RegisterHotKey(hotkey_window_, hotkey_open_menu, hk_menu_.modifier(), hk_menu_.virtkey()))
        {
            MessageBeep(0);
            hk_menu_.focus();
            return;
        }
    }
    config_->hotmenu = val;
    config_->smooth_hide = smooth_.is_checked();
    config_->winstart    = winstart_.is_checked();
    config_->hideicon    = hideicon_.is_checked();

    AnimateWindow(dlg_.hwnd(), 400, AW_BLEND | AW_HIDE);
    dlg_.close();
}

void settings_dlg::create()
{
    hk_hide_.set(config_->hideapp);
    hk_menu_.set(config_->hotmenu);
    smooth_.check(config_->smooth_hide);
    winstart_.check(config_->winstart);
    hideicon_.check(config_->hideicon);
}

} //
