

// $Id: icon.h,v 1.4 2008/02/24 17:16:44 enska Exp $

#ifndef STEALTH_ICON_H
#define STEALTH_ICON_H

#include <cassert>
#include <algorithm>
#include <windows.h>
#include "trayapp.h"

#undef min
#undef MIN

namespace trayapp
{
    class icon_view
    {
    public:
        void set_icon_array(const container* array)
        {
            array_ = array;
        }
        void move_selection_to_next_icon()
        {
            if (array_->empty())
                return ;
            selection_ = ++selection_ % array_->size();
        }
        void reset_selection()
        {
            selection_ = 0;
        }
        int selection() const
        {
            return selection_;
        }
    protected:
       ~icon_view() {}
        icon_view() :  array_(0), selection_(0) {}
        LRESULT paint(HWND hwnd, const PAINTSTRUCT& ps)
        {
            RECT rc;
            GetClientRect(hwnd, &rc);
            
            int cx = GetSystemMetrics(SM_CXICON);
            int cy = GetSystemMetrics(SM_CYICON);
            
            rc.right -= 20; // leave 10px gaps on each side.

            int width = cx + 10; // + gap
            int count = rc.right / width;
            int start = (rc.right - count * width) / 2;
            int row   = selection_ / count;
            int rowi  = selection_ % count; 

            count = std::min<int>(array_->size(), count);
            int min = std::min<int>(array_->size() - row * count, count);
            
            for (int i=row * count; i<row*count+min; ++i)
            {
                assert(i < static_cast<int>(array_->size()));
                if (i == selection_)
                {
                    RECT r;
                    r.top    = 18;
                    r.left   = start - 2;   
                    r.right  = start + cx + 2;
                    r.bottom = r.top + cy + 2;
                    FillRect(ps.hdc, &r, GetSysColorBrush(COLOR_HIGHLIGHT));
                    SetBkMode(ps.hdc, TRANSPARENT);
                    r = rc;
                    r.top = 20 + cy + 10;
                    DrawText(
                        ps.hdc,
                        (*array_)[i].caption.c_str(),
                        -1,
                        &r,
                        DT_CENTER | DT_END_ELLIPSIS);
                }
                DrawIcon(ps.hdc, start, 20, (*array_)[i].icon_large);
                start += width;
            }
            return TRUE;
        }
        LRESULT erase(HWND) 
        {
            return FALSE;
        }
    private:
        const container* array_;
        int selection_;
    };

} // trayapp

#endif // STEALTH_ICON_H
